
"""


Auteur: anonyme

Interface: microbit

Nom du projet: utiliser la touche sensitive

Description: No-description

Toolbox: vittascience

Mode: mixed

Blocks: <xml xmlns="https://developers.google.com/blockly/xml"><block type="on_start" id="G[=T#8yqB70`NFgYq}GP" deletable="false" x="-138" y="88"><statement name="DO"><block type="io_onPinPressed" id="Nq5xan[8Rz1eM_eq%{jJ"><field name="PIN">pin_logo</field><statement name="DO"><block type="actuators_playMusicGroveBuzzer" id="77?kT1rFoep7iseXiwo`"><field name="MUSIC">SW</field><field name="PIN">pin_speaker</field></block></statement></block></statement></block></xml>

Projet généré par Vittascience.

Ce fichier contient le code textuel ainsi que le code blocs. Il peut être importé de nouveau

sur l'interface http://vittascience.com/microbit


"""

from microbit import *
import utime

# Buzzer on pin_speaker

def pitch(pin, noteFrequency, noteDuration, silence_ms = 10):
  if noteFrequency is not 0:
    microsecondsPerWave = 1e6 / noteFrequency
    millisecondsPerCycle = 1000 / (microsecondsPerWave * 2)
    loopTime = noteDuration * millisecondsPerCycle
    for x in range(loopTime):
      pin.write_digital(1)
      utime.sleep_us(int(microsecondsPerWave))
      pin.write_digital(0)
      utime.sleep_us(int(microsecondsPerWave))
  else:
    utime.sleep_ms(noteDuration)
  utime.sleep_ms(silence_ms)

def BuzzerStarWars(pin):
  NOTES = [293.66, 293.66, 293.66, 392.0, 622.25, 554.37, 523.25, 454, 932.32, 622.25, 554.37, 523.25, 454, 932.32, 622.25, 554.37, 523.25, 554.37, 454]
  DURATIONS = [180, 180, 180, 800, 800, 180, 180, 180, 800, 400, 180, 180, 180, 800, 400, 180, 180, 180, 1000]
  SILENCE_DELAYS = [40, 40, 40, 100, 100, 40, 40, 40, 100, 50, 40, 40, 40, 100, 50, 40, 40, 40, 100]
  for i in range(len(NOTES)):
    pitch(pin, NOTES[i], DURATIONS[i], SILENCE_DELAYS[i])

if pin_logo.is_touched():
  BuzzerStarWars(pin_speaker)
